require( "scripts/style.lua" );
require( "scripts/game/trophyes.lua" );

CurrentFont=
{
  standardFont,
  30,
  BlackColor
  --Color(255,255,255,255)
};
--    
kCountTrophyesElem = 13;
kX1 = 30;
kX2 = 100;
kY = 80;
kDY = 50;

MakeDialog
{
    name="trophy_room",
    TrophyRoomWnd
    {
        x=0,
        y=0,
        w=800,
        h=600,
            Bitmap
            {
                name="backgroundimage",
                image="backgrounds/trophy_room.jpg",
                x=0,
                y=0,
                w=800,
                h=600
            };
--[[            
            Text
            {
                font = CurrentFont,
                name = "title",
                x=10,y=20,
                w=580, h=40,
                flags = kVAlignCenter + kHAlignCenter,
                label= "trophyroom",
            };
--]]            
--   
	        Particle
	        {
	            name = "trophy_particles_1",
	            x=215-80,
	            y=51-51,
	            w=200,
	            h=200,
	        },
	        Particle
	        {
	            name = "trophy_particles_2",
				x = 422-70,
				y = 45-45,
				w = 240,
				h = 200,
	        },
	        Particle
	        {
	            name = "trophy_particles_3",
				x = 555-60,
				y = 60,
				w = 200,
				h = 117,
	        },			
	        Particle
	        {
	            name = "trophy_particles_4",
				x = 404,
				y = 208,
				w = 200,
				h = 135,
	        },				
	        Particle
	        {
	            name = "trophy_particles_5",
				x = 189,
				y = 189,
				w = 220,
				h = 157,
	        },					
	        Particle
	        {
	            name = "trophy_particles_6",
				x = 536,
				y = 192,
				w = 200,
				h = 156,
	        },				
	        Particle
	        {
	            name = "trophy_particles_7",
				x = 60,
				y = 269,
				w = 220,
				h = 87,
	        },		
	        Particle
	        {
	            name = "trophy_particles_8",
				x = 0,
				y = 377,
				w = 220,
				h = 202,
	        },			
			
	        Particle
	        {
	            name = "trophy_particles_9",
				x = 376,
				y = 402,
				w = 220,
				h = 184,
	        },				
	        Particle
	        {
	            name = "trophy_particles_10",
				x = 550,
				y = 389,
				w = 240,
				h = 188,
	        },				
			
	        Particle
	        {
	            name = "trophy_particles_11",
				x = 206,
				y = 386,
				w = 230,
				h = 196,
	        },				
	        Particle
	        {
	            name = "trophy_particles_12",
				x = 250,
				y = 50,
				w = 220,
				h = 131,
	        },					
	        Particle
	        {
	            name = "trophy_particles_13",
				x = 290,
				y = 195,
				w = 220,
				h = 153,
	        },					
            Bitmap
            {
                name="trophy_img1",
                image="trophyes/trophy01.png",
				x = 215,
				y = 51,
				w = 104,
				h = 128,
            };
			
            Bitmap
            {
                name="trophy_img2",
                image="trophyes/trophy02.png",
				x = 422,
				y = 45,
				w = 161,
				h = 135,
            };
			
            Bitmap
            {
                name="trophy_img3",
                image="trophyes/trophy03.png",
				x = 555,
				y = 60,
				w = 118,
				h = 117,
            };
			
            Bitmap
            {
                name="trophy_img4",
                image="trophyes/trophy04.png",
				x = 444,
				y = 208,
				w = 159,
				h = 135,
            };
		
			
            Bitmap
            {
                name="trophy_img5",
                image="trophyes/trophy05.png",
				x = 249,
				y = 189,
				w = 124,
				h = 157,
            };
				
            Bitmap
            {
                name="trophy_img6",
                image="trophyes/trophy06.png",
				x = 576,
				y = 192,
				w = 167,
				h = 156,
            };
			
            Bitmap
            {
                name="trophy_img7",
                image="trophyes/trophy07.png",
				x = 106,
				y = 269,
				w = 187,
				h = 87,
            };
			
            Bitmap
            {
                name="trophy_img8",
                image="trophyes/trophy08.png",
				x = 9,
				y = 377,
				w = 263,
				h = 202,
            };
			
				
            Bitmap
            {
                name="trophy_img9",
                image="trophyes/trophy09.png",
				x = 396,
				y = 402,
				w = 252,
				h = 184,
            };
			
            Bitmap
            {
                name="trophy_img10",
                image="trophyes/trophy10.png",
				x = 570,
				y = 389,
				w = 191,
				h = 188,
            };
			
            Bitmap
            {
                name="trophy_img11",
                image="trophyes/trophy11.png",
				x = 206,
				y = 386,
				w = 259,
				h = 196,
            },
		
            Bitmap
            {
                name="trophy_img12",
                image="trophyes/trophy12.png",
				x = 312,
				y = 50,
				w = 131,
				h = 131,
            },
			
            Bitmap
            {
                name="trophy_img13",
                image="trophyes/trophy13.png",
				x = 349,
				y = 195,
				w = 109,
				h = 153,
            };			
			
-- end
            HintTrophy 
            {
                name="hint",
                image="backgrounds/maphint.png",
                x=100,
                y=100,
                w=800,
                h=600,
                maxY = 550,
                deltaAlpha = 0.1,
                image_pos_x = 50, --      
                image_pos_y = 65, --      
                delta_text_x = 0, --        (   trophies  delta_x)
                -- (  )
                trophies = {
                    { 
                        rect={198,46,300,170}, 
                        background="trophyes/hint_right.png",  
                        img="buttons/pad_but.png",
                        text="trophy_description_text_1",
                        text_no_taken="trophy_text_no_taken_1",
                        pos_x=242,pos_y=2,
                        delta_x=47
                    };
                    { 
                        rect={416,37,540,160}, 
                        background="trophyes/hint_left.png",  
                        img="buttons/pad_but.png",
                        text="trophy_description_text_2",
                        text_no_taken="trophy_text_no_taken_2",
                        pos_x=162,pos_y=15
                    };
                    { 
                        rect={553,63,623,171}, 
                        background="trophyes/hint_left.png",  
                        img="buttons/pad_but.png",
                        text="trophy_description_text_3",
                        text_no_taken="trophy_text_no_taken_3",
                        pos_x=273,pos_y=10
                    };
                    { 
                        rect={434,196,570,350}, 
                        background="trophyes/hint_left.png",
                        img="buttons/pad_but.png",
                        text="trophy_description_text_4",
                        text_no_taken="trophy_text_no_taken_4",
                        pos_x=126,pos_y=155,

                    };
                    { 
                        rect={254,186,340,340}, 
                        background="trophyes/hint_right.png",
                        img="buttons/pad_but.png",
                        text="trophy_description_text_5",
                        text_no_taken="trophy_text_no_taken_5",
                        pos_x=300,pos_y=190,
                        delta_x=47
                    };
                    { 
                        rect={572,186,700,340}, 
                        background="trophyes/hint_left.png",
                        img="buttons/pad_but.png",
                        text="trophy_description_text_6",
                        text_no_taken="trophy_text_no_taken_6",
                        pos_x=300,pos_y=180
						
                    };
                    { 
                        rect={90,255,250,340}, 
                        background="trophyes/hint_right.png",
                        img="buttons/pad_but.png",
                        text="trophy_description_text_7",
                        text_no_taken="trophy_text_no_taken_7",
                        pos_x=150,pos_y=230,
						delta_x=47
                    };
                    { 
                        rect={33,384,200,577}, 
                        background="trophyes/hint_right.png",
                        img="buttons/pad_but.png",
                        text="trophy_description_text_8",
                        text_no_taken="trophy_text_no_taken_8",
                        pos_x=119,pos_y=370,
                        delta_x=47
                    };
                    { 
						rect={210,398,400,570}, 
                        
                        background="trophyes/hint_right.png",  
                        img="buttons/pad_but.png",
                        text="trophy_description_text_9",
                        text_no_taken="trophy_text_no_taken_9",
                        pos_x=310,pos_y=368,
                        delta_x=47
                    };
                    { 
                        rect={408,401,560,580}, 
                        background="trophyes/hint_left.png",
                        img="buttons/pad_but.png",
                        text="trophy_description_text_10",
                        text_no_taken="trophy_text_no_taken_10",
                        pos_x=190,pos_y=370
                    },
                    { 
                        rect={568,387,740,540}, 
                        background="trophyes/hint_left.png",
                        img="buttons/pad_but.png",
                        text="trophy_description_text_11",
                        text_no_taken="trophy_text_no_taken_11",
                        pos_x=320,pos_y=370
                    },
                    { 
                        rect={298,42,400,170}, 
                        background="trophyes/hint_right.png",
                        img="buttons/pad_but.png",
                        text="trophy_description_text_12",
                        text_no_taken="trophy_text_no_taken_12",
                        pos_x=350,pos_y=50,
						delta_x=47
                    },
					{
                        rect={342,192,430,350}, 
                        background="trophyes/hint_right.png",
                        img="buttons/pad_but.png",
                        text="trophy_description_text_13",
                        text_no_taken="trophy_text_no_taken_13",
                        pos_x=390,pos_y=180,
						delta_x=47
                    };
                },
--[[                
                Bitmap
                {
                    name="hint_trophy_img1",
                    image="buttons/pad_but.png",
                    x=0,
                    y=0,
                    w=100,
                    h=100,
                    flags = kHAlignCenter + kVAlignCenter,
                };
--]]                
                Text
                {
                    name = "hint_trophy_text1",
                    font = CurrentFont,
                    x=14,
                    y=0,
                    w=278, h=128,        --TODO:    
                    flags = kHAlignCenter + kVAlignCenter,
                    label= "trophy_description_text_1",
                };
            };
            
            Button
            {
                x = 650,
                y = 10, --550,
                graphics = StButtonGraphicsSm,
                font = MenuButtonFont;
                name="ok",
                label="ok",
                sound=kDefaultButtonSound,                            
                type = kPush,
                command =
                    function()
                        PopModal("trophy_room");
                    end
            };
            Button
            {
                x = 18,
                y = 10, --550,
                graphics = StButtonGraphicsSm,
                font = MenuButtonFont;
                name="statistic_btn",
                label="statistic_btn",
                sound=kDefaultButtonSound,                            
                type = kPush,
                command =
                    function()
                        DoModal("scripts/statistic_wnd.lua");
                    end
            };
    };
}





function InitTrophyes()
    SetGotTrophyes();
    local countTrophyes = table.getn(trophyes);
    local on_trophy = 0;
    for ind = 1, countTrophyes, 1 do
        on_trophy = 0;
        if (trophyes[ind].taking == 1) then
            --index = index + 1;
            if (ind <= kCountTrophyesElem) then
                EnableWindow("trophy_img"..ind,true);
                on_trophy = 1;
            end
        end
        if (on_trophy == 0) then
            EnableWindow("trophy_img"..ind,false);
        end
    end
    --       
    for ind1 = countTrophyes + 1, kCountTrophyesElem, 1 do
        EnableWindow("trophy_img"..ind1,false);
    end
	--LastLevelTrophys={13};
	
	if LastLevelTrophys ~= nil and table.getn(LastLevelTrophys) then
		for i=1, table.getn(LastLevelTrophys) do
			 StartParticles( "trophy_particles_"..LastLevelTrophys[i], "trophy_particle");
		end
	end
end

InitTrophyes();

